<?php get_header(); ?>

	<div id="content" class="content">

		<main id="main" role="main">
			<section<?php if ( !is_single() ): ?> class="archives"<?php endif; ?>>

<?php if ( have_posts() ): ?>

				<header class="page-header">
					<h1 class="page-title">新着情報<a href="<?php echo home_url();?>/news/"><small>一覧へ</small></a></h1>
				</header>

<?php while ( have_posts() ) : the_post(); ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<?php if ( has_post_thumbnail()) : ?>
					<div class="thumbnail">
						<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_post_thumbnail(); ?></a>
					</div>
					<?php endif; ?>

					<h1 class="post-title"><?php the_title(); ?></h1>
					<?php get_template_part('parts/postmeta',''); /* parts/postmeta.php をインクルード */ ?>

					<?php single_pagination(); ?>

					<div class="post-content">
						<?php the_content(); ?>
					</div>

					<?php single_pagination(); ?>

					<?php if ( get_the_tags() ): ?>
					<p class="tags">
						<span class="dashicons-before dashicons-tag"><b>タグ：</b></span><?php the_tags( '',', ','' ); ?>
					</p>
					<?php endif; ?>

				</article>

				<div class="single_nav">
					<p class="prev"><?php previous_post_link('%link','&laquo; 前の投稿'); ?></p>
					<p class="next"><?php next_post_link('%link','次の投稿 &raquo;'); ?></p>
				</div>

				<?php if ( comments_open() || get_comments_number() ): ?>
				<div id="comments_area">
					<?php comments_template(); ?>
				</div>
				<?php endif; ?>

<?php endwhile; ?>

<?php else: ?>

				<article>
					<header class="page-header">
						<h1 class="page-title">Not found.</h1>
					</header>
					<div class="page-content notfound">
						<p>お探しのページが見つかりませんでした。検索をお試しください。</p>
						<?php get_search_form(); ?>
					</div><!-- .page-content -->
				</article>

<?php endif; ?>

			</section>
		</main>

<?php get_sidebar(); ?>

	</div><!-- #content -->

<?php get_footer(); ?>
