<?php
// generator非表示
if ( has_action( 'wp_head', 'wp_generator' ) )
	remove_action( 'wp_head', 'wp_generator' );

// 投稿のみアイキャッチを使用する
if ( function_exists( 'add_theme_support' ) )
	add_theme_support( 'post-thumbnails', array( 'post' ) );

// テーマでDashiconsを使用する
function load_dashicons() {
	wp_enqueue_style('dashicons');
}
add_action( 'wp_print_styles', 'load_dashicons');

// パンくずリストを追加
include( 'parts/breadcrumbs.php' );


/*--------------------------------------------------
  ヘッダー
--------------------------------------------------*/

if ( function_exists( 'add_theme_support' ) )
	// RSSフィードへのリンクを追加
	add_theme_support( 'automatic-feed-links' );
	// titleタグを出力
	add_theme_support( 'title-tag' );

// サイトトップページのドキュメントタイトルからdescriptionを取り除く
add_filter( 'pre_get_document_title', function ( $title ) {
	if(is_front_page()){
		$title = get_bloginfo();
	}
	return $title;
}, 10, 2 );

// WordPress同梱のjQueryにテーマフォルダ内のcommon.jsをリンクする
function my_scripts_method() {
	wp_enqueue_script(
		'custom-script',
		get_stylesheet_directory_uri() . '/js/common.js',
		array( 'jquery' )
	);
}
add_action( 'wp_enqueue_scripts', 'my_scripts_method' );


/*--------------------------------------------------
  ナビゲーション
--------------------------------------------------*/

// カスタムメニューエリアの設定
register_nav_menus( array(
	'main_nav'	 => esc_html('メインナビゲーション'),
	'sub_nav'	 => esc_html('サブナビゲーション'),
) );

// サブナビゲーション未設定時に「お問い合わせ」ページへのリンクを表示
function contact_page_link() {
	echo '<ul id="sub-menu"><li><a href="'.home_url().'/contact/" class="dashicons-before dashicons-email">お問い合わせ</a></li></ul>';
}

// 指定したスラッグから任意の固定ページメニューを生成
function custom_page_list( $include_slug, $menu_id='', $sub_menu=false ) {
	global $post;
	if( $menu_id ) { $menu_id = ' id="'.$menu_id.'"'; }

	// メニューに含める固定ページのIDを設定
	$include_id = array();
	if( $include_slug ) {
		foreach ( $include_slug as $slug ) {
			$get_page_id = get_page_by_path($slug)->ID;
			array_push($include_id,$get_page_id);
		}
	}

	// メニューに含めるページのクエリを取得
	$args = array(
		'include'		 => $include_id,
		'sort_column'	 => 'menu_order',
		'sort_order'	 => 'ASC',
		'post_type'		 => 'page',
	);
	$pages = get_pages($args);

	// メニュー出力
	echo '<ul'.$menu_id.'>'."\n";
	foreach ($pages as $page) {
		$page_id = $page->ID;
		$children = wp_list_pages( 'echo=0&title_li=&child_of='.$page_id );

		if( $page_id == $post->ID ) { $current = ' class="current_page_item"'; }
		elseif( in_array( $page_id, get_post_ancestors( $post->ID ) ) ) { $current = ' class="current_page_ancestor"'; }
		else { $current = ''; }

		echo '<li'.$current.'><a href="'.get_bloginfo('url').'/'.$page->post_name.'/">'.$page->post_title.'</a>';
		if( $children and $sub_menu ) {
			echo "\n".'<ul class="sub-page">'."\n";
			echo $children;
			echo '</ul>'."\n";
		}
		echo '</li>'."\n";
	}
	echo '</ul>'."\n";

}


/*--------------------------------------------------
  サイドバー
--------------------------------------------------*/

// ウィジェットエリアの設定
if (function_exists('register_sidebar')) {
	register_sidebar(array(
		'name'			 => 'Widget Area 1',
		'description'	 => '',
		'id'			 => 'widget-area-1',
		'before_widget'	 => '<div id="%1$s" class="%2$s">',
		'after_widget'	 => '</div>',
		'before_title'	 => '<h3 class="widget-title">',
		'after_title'	 => '</h3>'
	));
	register_sidebar(array(
		'name'			 => 'Widget Area 2',
		'description'	 => '',
		'id'			 => 'widget-area-2',
		'before_widget'	 => '<div id="%1$s" class="%2$s">',
		'after_widget'	 => '</div>',
		'before_title'	 => '<h3 class="widget-title">',
		'after_title'	 => '</h3>'
	));
}


/*--------------------------------------------------
  固定ページ
--------------------------------------------------*/

// 固定ページではビジュアルエディタを使用しない
function disable_visual_editor_in_page(){
	global $typenow;
	if( $typenow == 'page' ){
		add_filter('user_can_richedit', 'disable_visual_editor_filter');
	}
}
function disable_visual_editor_filter(){
	return false;
}
add_action( 'load-post.php', 'disable_visual_editor_in_page' );
add_action( 'load-post-new.php', 'disable_visual_editor_in_page' );

// 親ページのスラッグを取得
function is_parent_slug() {
	global $post;
	if ($post->post_parent) {
		$post_data = get_post($post->post_parent);
		return $post_data->post_name;
	}
}


/*--------------------------------------------------
  投稿
--------------------------------------------------*/

// ビジュアルエディタにテーマのスタイルを適用
add_editor_style( 'style.css' );

// ビジュアルエディタTinyMCEの編集エリアに独自クラス(post-content)を追加
function custom_editor_settings( $initArray ){
	$initArray['body_class'] = 'post-content';
	return $initArray;
}
add_filter( 'tiny_mce_before_init', 'custom_editor_settings' );

// moreタグに独自クラス(clear)を追加
function add_more_class($content) {
	$content = preg_replace('/<span id="more-([0-9]+?)"><\/span>/', '<span class="clear" id="more-$1"></span>', $content);
	return $content;
}
add_action('the_content', 'add_more_class');

// 一覧ページのページナビゲーション
function archives_pagination() {
	global $wp_query;
	$big = 999999999; // need an unlikely integer
	$translated = __( 'Page', 'mytextdomain' ); // Supply translatable string
	$args = array(
		'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		'format' => '?paged=%#%',
		'current' => max( 1, get_query_var('paged') ),
		'total' => $wp_query->max_num_pages,
		'before_page_number' => '<span class="screen-reader-text">' . $translated . ' </span>'
	);
	echo '<div class="archives_pagination pagination">'."\n";
	echo paginate_links($args)."\n";
	echo '</div>'."\n";
}

// シングルページの改ページナビゲーション
function single_pagination() {
	global $page, $numpages, $multipage, $more;
	if( $multipage ) {
		if( $i = ( $page - 1 ) ) {
			$prev_link = _wp_link_page( $i ) . '&laquo; prev</a>';
		}
		if( $page < $numpages ) {
			$next_link = _wp_link_page( $i = $page + 1 ) . 'next &raquo;</a>';
		}
		$args = array(
			'before'			 => '',
			'after'				 => '',
			'link_before'		 => '<span class="page-numbers">',
			'link_after'		 => '</span>',
			'next_or_number'	 => 'number',
			'separator'			 => '',
			'echo'				 => 0
		);
		echo '<div class="single_pagination pagination">'."\n";
		echo '<span class="prev">' . $prev_link . '</span>'."\n";
		echo '<span class="pages">' . wp_link_pages($args) . ' </span>';
		echo '<span class="next">' . $next_link . '</span>'."\n";
		echo '</div>'."\n";
	}
}

// 抜粋の文字数変更
function change_excerpt_mblength($length) {
	return 88;
}
add_filter('excerpt_mblength', 'change_excerpt_mblength');


/*--------------------------------------------------
  管理画面
--------------------------------------------------*/

// 管理メニューの項目名「投稿」を「新着情報」に変更
function change_post_label() {
	global $menu;
	global $submenu;

	$menu[5][0] = '新着情報'; // 投稿を新着情報に変更
	$submenu['edit.php'][5][0] = '新着情報一覧'; // 投稿一覧を新着情報一覧に変更
}
add_action( 'admin_menu', 'change_post_label' );

// 管理メニューから不要な項目を取り除く(管理者以外)
function remove_menus () {
	global $menu;
	//var_dump($menu);
	if (!current_user_can('administrator')) { //管理者ではない場合
//		remove_menu_page( 'index.php' );				// ダッシュボード
//		remove_menu_page( 'edit.php' );				// 投稿
		remove_menu_page( 'upload.php' );				// メディア
		remove_menu_page( 'edit.php?post_type=page' );	// 固定ページ
		remove_menu_page( 'edit-comments.php' );		// コメント
		remove_menu_page( 'themes.php' );				// 外観
		remove_menu_page( 'plugins.php' );				// プラグイン
//		remove_menu_page( 'users.php' );				// ユーザー
		remove_menu_page( 'tools.php' );				// ツール
		remove_menu_page( 'options-general.php' );		// 設定

		remove_menu_page('wpcf7');
	}
}
add_action('admin_menu', 'remove_menus');

// ------------------------------------------------------------
// 管理バーの項目名「投稿」を「新着情報」に変更
// (項目を一旦削除）
function my_remove_default_new_content_menu() {
	global $wp_admin_bar;
	$wp_admin_bar->remove_menu('new-post');
}
add_action( 'wp_before_admin_bar_render', 'my_remove_default_new_content_menu' );
// (項目名を変更して再登録）
function my_new_content_menu() {
	global $wp_admin_bar;
	$wp_admin_bar->add_menu( array(
		'parent' => 'new-content',
		'id' => 'new_post',
		'title' => '新着情報',
		'href' => admin_url( 'post-new.php?post_type=post' ),
	));
}
add_action( 'wp_before_admin_bar_render', 'my_new_content_menu' );

// 管理バーから不要な項目を取り除く(管理者以外)
function remove_bar_menus( $wp_admin_bar ) {
	if (!current_user_can('administrator')) { //管理者ではない場合
		$wp_admin_bar->remove_menu( 'comments' );	// コメント
		$wp_admin_bar->remove_menu( 'new-media' );	// 新規 -> メディア
		$wp_admin_bar->remove_menu( 'new-page' );	// 新規 -> 固定ページ
	}
}
add_action('admin_bar_menu', 'remove_bar_menus', 201);

// ------------------------------------------------------------
// ダッシュボードから不要なウィジェットを取り除く(管理者以外)
function example_remove_dashboard_widgets() {
	if (!current_user_can('administrator')) { //管理者ではない場合
		global $wp_meta_boxes;
		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']); // 概要
//		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity']);	 // アクティビティ
		unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']); // クイックドラフト
		unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);	 // WordPressニュース
	}
}
add_action('wp_dashboard_setup', 'example_remove_dashboard_widgets');
