<!doctype html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="description" content="<?php bloginfo('description'); ?>">

		<title><?php wp_title('|',true,'right'); bloginfo('name'); ?></title>

        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon.ico" rel="shortcut icon">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/apple-touch-icon-precomposed.png" rel="apple-touch-icon-precomposed">

		<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/style.css?ver=<?php echo filemtime(__DIR__.'/style.css')?>" type="text/css" media="all">

		<!--[if lt IE 9]>
			<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
			<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->

		<?php wp_head(); ?>

	</head>

	<body <?php
		if( is_page() ){
			if( $post->post_parent ) { $parent = ' page-'.get_post( $post->post_parent )->post_name; } else { $parent = ''; }
			body_class('page-'.get_post( $post )->post_name.$parent);
		}
		else {
			body_class();
		}
	?>>

		<div id="wrapper">

			<header id="site_header" class="header" role="banner">

					<<?php if( is_front_page() ): ?>h1<?php else: ?>p<?php endif; ?> id="header_logo" class="logo">
						<a href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?>">
							<img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" width="300" height="50" alt="<?php bloginfo('name'); ?>" class="logo-img">
						</a>
					</<?php if( is_front_page() ): ?>h1<?php else: ?>p<?php endif; ?>><!-- #header_logo -->

					<p id="site_description">
						<?php bloginfo('description'); ?>
					</p>

					<nav id="header_nav" class="nav" role="navigation">
						<button class="menu-toggle" aria-controls="header-menu" aria-expanded="false"><span class="dashicons dashicons-menu"></span><span>Main Menu</span></button>
						<?php wp_nav_menu( array( 'theme_location' => 'main_nav', 'menu_id' => 'header-menu' ) ); ?>
						<p id="contact_btn"><a href="<?php echo home_url(); ?>/contact/" class="dashicons-before dashicons-email" title="お問い合わせ">お問い合わせ</a></p>
					</nav><!-- #header_nav -->

			</header><!-- #site_header -->

			<?php get_breadcrumb('ホーム','新着情報','news'); /* サイトトップページ名、投稿トップページ名、投稿トップページスラッグを設定 */ ?>

