<?php get_header(); ?>

	<div id="content" class="<?php if ( is_category() ): ?>news_content<?php else: ?>content<?php endif; ?>">

		<main id="main" role="main">
			<section class="archives">

<?php if ( have_posts() ): ?>

				<header class="page-header">
					<h1 class="page-title">新着情報<a href="<?php echo home_url();?>/news/"><small>一覧へ</small></a></h1>
					<h2 class="category-title"><?php
					/* カテゴリー */
					if ( is_category() ):
						echo single_cat_title( '', false );
					/* 投稿者 */
					elseif ( is_author() ):
						echo '“'.get_the_author().'”のアーカイブ';
					/* タグ */
					elseif ( is_tag() ):
						echo '“'.single_tag_title( '', false ).'”のアーカイブ';
					else:
						/* その他 */
						if ( is_day() ):
							echo get_the_date('Y年n月j日').' のアーカイブ';
						elseif ( is_month() ):
							echo get_the_date('Y年n月').' のアーカイブ';
						elseif ( is_year() ):
							echo get_the_date('Y年').' のアーカイブ';
						else :
							echo 'アーカイブ';
						endif;
					endif;
					?></h2>
				</header>

				<?php
				if ( is_category() ):
					get_template_part('parts/loop','news');
				else:
					get_template_part('parts/loop','archive');
				endif;
				?>

				<?php archives_pagination(); ?>

<?php else: ?>

				<article>
					<header class="page-header">
						<h1 class="page-title">Not found.</h1>
					</header>
					<div class="page-content notfound">
						<p>お探しのページが見つかりませんでした。検索をお試しください。</p>
						<?php get_search_form(); ?>
					</div><!-- .page-content -->
				</article>

<?php endif; ?>

			</section>
		</main>

		<?php get_sidebar(); ?>

	</div><!-- #content -->

<?php get_footer(); ?>
