<?php get_header(); ?>

	<div id="main_visual">
		<img src="<?php echo get_template_directory_uri(); ?>/images/main_visual.png">
	</div>

	<div id="content" class="page_content">

		<main id="main" role="main">
			<section>

<?php if (have_posts()): while (have_posts()) : the_post(); ?>

			<?php if ( get_the_content() ): ?>

				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<div class="page-content">
						<?php the_content(); ?>
					</div>

				</article>

			<?php endif; ?>

<?php endwhile; endif; ?>


				<div id="topics" class="news_content">

					<h2 class="title">新着情報<a href="<?php echo home_url(); ?>/news/"><small>一覧へ</small></a></h2>

<?php
// 新着情報カテゴリー抽出
$terms = get_terms( 'category',array( 'hide_empty' => 0 ) );
$i=0; foreach( $terms as $term ) { $categories[$i] = $term->slug; $i++; }
$ext = $categories;
if( get_post_ancestors( $post->ID ) ) { $ext = get_post($post)->post_name; }

$temp = $wp_query;
$wp_query = null;
$args = array(
		'post_type' => 'post',
		'posts_per_page' => 5,
		'tax_query' => array(
			'relation' => 'AND',
			array(
				'taxonomy' => 'category',
				'field'    => 'slug',
				'terms'    => $ext,
				'operator' => 'IN',
			),
			array(
				'taxonomy' => 'category',
				'field'    => 'slug',
				'terms'    => '',	//除外カテゴリー
				'operator' => 'NOT IN',
			),
		),
	);
$wp_query = new WP_Query( $args );
?>
<?php if ( $wp_query->have_posts() ): while ( $wp_query->have_posts() ): $wp_query->the_post(); ?>

					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

						<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
	
						<span class="date"><?php echo get_post_time('Y.m.d'); ?></span>
						<span class="post-title"><?php the_title(); ?></span>

						</a>
	
					</article>

<?php endwhile; endif; wp_reset_query(); ?>

				</div>



			</section>
		</main>

		<aside id="banner" role="complementary">
			<ul>
				<li><a href="<?php echo home_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/banner.png"></a></li>
				<li><a href="<?php echo home_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/banner.png"></a></li>
				<li><a href="<?php echo home_url(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/banner.png"></a></li>
			</ul>
		</aside>

	</div><!-- #content -->

<?php get_footer(); ?>
