<?php
function get_breadcrumb( $home_name, $title, $slug ) {

	$delimiter = '&raquo;';
	$currentBefore = '<span class="current">';
	$currentAfter = '</span>';

	if ( ! $home_name ) { $home_name = 'Home'; }
	if ( $title and $slug ) {
		$post_home = '<a href="' . get_bloginfo('url') . '/' . $slug . '/">' . $title . '</a> ' . $delimiter . ' ';
	} else { $post_home = ''; }


	if ( !is_front_page() ) {
		global $post;
		echo '<div id="breadcrumb">';
		echo '<a href="' . get_bloginfo('url') . '">' . $home_name . '</a> ' . $delimiter . ' ';

		if ( is_home() ) {
			echo $title;
		} elseif ( is_category() ) {
			global $wp_query;
			$cat_obj = $wp_query->get_queried_object();
			$thisCat = $cat_obj->term_id;
			$thisCat = get_category($thisCat);
			$parentCat = get_category($thisCat->parent);
			if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
			echo $post_home;
			echo $currentBefore . single_cat_title() . $currentAfter;
		} elseif ( is_day() ) {
			echo $post_home;
			echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y年') . '</a> ' . $delimiter . ' ';
			echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
			echo $currentBefore . get_the_time('d日') . $currentAfter;
		} elseif ( is_month() ) {
			echo $post_home;
			echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y年') . '</a> ' . $delimiter . ' ';
			echo $currentBefore . get_the_time('F') . $currentAfter;
		} elseif ( is_year() ) {
			echo $post_home;
			echo $currentBefore . get_the_time('Y年') . $currentAfter;
		} elseif ( is_single() ) {
			$cat = get_the_category(); $cat = $cat[0];
			echo $post_home;
			echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
			echo $currentBefore . get_the_title() . $currentAfter;
		} elseif ( is_page() && !$post->post_parent ) {
			echo $currentBefore . get_the_title() . $currentAfter;
		} elseif ( is_page() && $post->post_parent ) {
			$parent_id = $post->post_parent;
			$breadcrumbs = array();
			while ($parent_id) {
				$page = get_page($parent_id);
				$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
				$parent_id = $page->post_parent;
			}
			$breadcrumbs = array_reverse($breadcrumbs);
			foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
			echo $currentBefore . get_the_title() . $currentAfter;
		} elseif ( is_search() ) {
			echo $currentBefore . '“' . get_search_query() . '”の検索結果' . $currentAfter;
		} elseif ( is_tag() ) {
			echo $post_home;
			echo $currentBefore . '“' . single_tag_title('',false) . '”のアーカイブ' . $currentAfter;
		} elseif ( is_author() ) {
			echo $post_home;
			global $author;
			$userdata = get_userdata($author);
			echo $currentBefore . '“' . $userdata->display_name . '”のアーカイブ' . $currentAfter;
		} elseif ( is_404() ) {
			echo $post_home;
			echo $currentBefore . 'Error 404' . $currentAfter;
		}
		if ( get_query_var('paged') ) {
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
			echo __('Page') . ' ' . get_query_var('paged');
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
		}
		echo '</div>';
	}
}
